<?php
include("../includes/config.php");
include("../includes/db_connect.php");
include("../includes/upload.class.php");
include("../includes/functions.php");

$result = array();

if(	isset($_POST["page_id"]) ) 
{
		
	$page_id 		= $_POST["page_id"];
	
	if(TEST_MODE) {
		$error = "You can't delete this page in demo mode.";
		$result["has_error"] = true;
		$result["error"] = 998;
		$result["error_txt"] = $error;
	} else {
	
		if($_SESSION["RANK"] < 1) {
	
			$result["status"] = 0;
			$result["error"] = "You're not an admin";
			
		} else {
			
			$stmt = $dbh->prepare("	DELETE FROM custom_page
									WHERE id = :page_id
									");
			$stmt->bindParam(':page_id', $page_id);
			$stmt->execute();
			
			$result["status"] = 1;
			
		}
	
	}

		
} else {
	
	$result["error"] = 998;
	$result["has_error"] = true;
	$result["error_txt"] = "This user doesn't exist anymore.";
	
}

echo json_encode($result);
?>